#include "client.h"
      
// constructeur 
Client::Client(int iNumClient, SOCKET Socket)
:m_iNumClient(iNumClient), m_Socket(Socket), m_bReady(false),
 m_bDisconnected(false)
{
    this->m_szNomJoueur = new char[50];
    this->recupNom();
 }
        
//destructeur
Client::~Client()
{
    //fermeture du socket de connection avec le client
    closesocket(this->m_Socket);
}
        
// cherche les evnements donns par le client sur le rseau
// et retourne cette liste des vnements
vector<char>* Client::getEvents()
{
    char buffer[1000];
    int iSize;
    vector<char> *pEvents;
    
    pEvents=new vector<char>;
    
    //recoit les vnements du client
    iSize = recv(this->m_Socket, buffer, sizeof(buffer),0);
    
    if (iSize==-1)
    {
        printf("Erreur de recepetion des evenements du joueur %d\n", this->getNumero());
        this->m_bDisconnected=true;
    }
    
    //ajout de tous les vnements dans le vecteur
    // note : on ne prend pas le dernier octet qui est toujours egal  zero
    // et qui est toujours envoy (mme s'il n'y a pas d'vnements
    for ( int i = 0; i < iSize -1 ; i++)
    {
        pEvents->push_back(buffer[i]);
    }
    
    return pEvents;
}
        
// retourne le numero de joueur de l'instance de Client
int Client::getNumero()
{
    return this->m_iNumClient;
}
        
// envoie le package p au client sur le rseau
void Client::sendPackage(Package *p)
{
    int iRet;
    iRet = send(this->m_Socket, p->getBuffer(), p->getBufferLenght(),0);
    if ( iRet ==-1)
    {
        printf("Erreur de connection au joueur %d.\n",this->getNumero());
        this->m_bDisconnected=true;
    }
     
}
 
// envoie un go au client pour lui dire de dmarrer la partie
void Client::sendGo()
{
    char *mess = "go";
    int ret;
    printf("Envoie du go au joueur %d...\n",this->getNumero());
    
    ret = send(this->m_Socket, mess, sizeof(char[3])*strlen(mess),0); 
    if ( ret ==-1)
    {
        printf("Erreur de connection au joueur %d.\n",this->getNumero());
        this->m_bDisconnected=true;
    }
    printf("Joueur %d partie demarree.\n",this->getNumero());
    
}        
 

//recupre le nom du joueur
void Client::recupNom()
{
    int ret;
    char mess[50];
    ret = recv(this->m_Socket,mess, sizeof(mess),0);
    if (ret == -1)
    {
        printf("Erreur de lecture sur la connection du joueur %d\n",this->getNumero());
        this->m_bDisconnected=true;
    }
    // copie le nom du joueur dans le
    mess[ret]='\0';
    strcpy(this->m_szNomJoueur,mess);
    printf("Nom du joueur %d : %s\n", this->getNumero(),this->m_szNomJoueur);
}
      
// attends que le client soit prt
void Client::waitReady()
{
    int ret;
    char mess[10];

    printf("Attente du ready du joueur %d...\n",this->getNumero());
    // lit plusieurs octets sur la connection
    ret = recv(this->m_Socket,mess, sizeof(mess),0);
    if (ret == -1)
    {
        printf("Erreur de lecture sur la connection du joueur %d\n",this->getNumero());
        this->m_bDisconnected=true;
    }
    printf("Joueur %d ready !\n",this->getNumero());
    
}

// attends que le client envoi quelque chose sur la connection
// sert  sychroniser l'envoi des noms
void Client::wait()
{
    int ret;
    char mess[10];

    // lit plusieurs octets sur la connection
    ret = recv(this->m_Socket,mess, sizeof(mess),0);
    if (ret == -1)
    {
        printf("Erreur de lecture sur la connection du joueur %d\n",this->getNumero());
        this->m_bDisconnected=true;
    }
    
}

// retourne true si le client est dconnect et false sinon
bool Client::isDisconnected()
{
    return this->m_bDisconnected;
}

// envoie un buffer au client de taille nbOctets
void Client::sendBuffer(char * szBuffer, int nbOctets)
{
    int iRet;
    iRet = send(this->m_Socket, szBuffer, nbOctets,0);
    if ( iRet ==-1)
    {
        printf("Erreur de connection au joueur %d.\n",this->getNumero());
        this->m_bDisconnected=true;
    }
}
